DROP PROCEDURE [hips].[EpisodeProviderGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Philip SG
-- Create date: 06 June 2013
-- Description:   Gets a specific record/records from the Episode and Provider Table

-- =============================================
CREATE PROCEDURE [hips].[EpisodeProviderGet] 
(
	@EpisodeId INT = NULL,
	@PatientId INT = NULL,
	@DateLastUpdated DATETIME = NULL
)
AS
BEGIN
SELECT DISTINCT 
		hcp.HealthProviderIndividualId,
		hcp.IamProviderIdentifier,
		hcp.HpiI,
		hcp.HpiILastValidatedDate,		
		hcp.TitleId,
		t.Description AS Title,		
		hcp.FamilyName,
		hcp.GivenNames,		
		hcp.SuffixId,
		s.Description AS Suffix,
		hcp.DateCreated,
		hcp.UserCreated,
		hcp.DateModified,
		hcp.UserModified
FROM hips.Episode e
INNER JOIN hips.HealthProviderIndividual AS hcp ON hcp.HealthProviderIndividualId = e.ResponsibleProviderId
INNER JOIN hips.Title AS t ON t.TitleId = hcp.TitleId
INNER JOIN hips.Suffix AS s ON s.SuffixId = hcp.SuffixId
WHERE (@EpisodeId IS NULL OR e.EpisodeId = @EpisodeId)
AND   (@PatientId IS NULL OR e.PatientId = @PatientId)
AND   (@DateLastUpdated IS NULL OR e.DateModified > @DateLastUpdated)


END
GO

